/*------------------------------------------------------------------------------*
 * File Name:				 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h>
////////////////////////////////////////////////////////////////////////////////////
#include <ocmath.h>
#include <GetNBox.h>
#include "ImagePreview.h"

////////////////////////////////////////////////////////////////////////////////////
// Include your own header files here.

static bool mat_nl_filter(matrix<ushort>& mat, double dPercent, int nWinSize, int nShape, double dThreshold = 0)
{
	waitCursor junk;
	int nRows = mat.GetNumRows();
	int nCols = mat.GetNumCols();
	DWORD dwTick = GetTickCount();
	LT_execute("type -a");// show script window
	out_str("Please wait for percentile filter...");
	printf("R x C = %d x %d, percent = %4.1f, size = %d, type = %d\n", nRows, nCols, dPercent, nWinSize, nShape);
	///Mouqx/Leo 2005-9-26 QA70-8110 TO_CENTRALIZE_ERROR_CODES_IN_OCMATH
	//bool bOk = ocmath_us_percentile_filter(mat, nRows, nCols, dPercent, nWinSize, nWinSize, nShape, dThreshold);
	int nRet = ocmath_us_percentile_filter(mat, nRows, nCols, dPercent, nWinSize, nWinSize, nShape, dThreshold);
	printf("Time elapsed = %f secs\n", (GetTickCount()-dwTick)/1000.0);
	//return bOk;
	return (nRet == OE_NOERROR);
	//END TO_CENTRALIZE_ERROR_CODES_IN_OCMATH
}

static string s_strSourceMatName;
static string s_strTempMatName;

bool preview_filtered_result(TreeNode& myTree)
{
	MatrixPage matPreview(s_strTempMatName);
	MatrixPage matSrc(s_strSourceMatName);
	if(!matSrc)
		return false;
	
	if(!matPreview)
	{
		matPreview.Create("origin.otm", CREATE_HIDDEN);
	}
	image_percentile_filter(s_strSourceMatName, myTree, matPreview);
		
	matPreview.GetName(s_strTempMatName);
	return true;
}

class PercentileFilterPreview : public ImagePreview
{
protected:
	virtual bool OnUpdatePreview(TreeNode tr)
	{
		MatrixPage mp(m_strSrcMatrix);
		if(!mp)
			return false;
	
		MatrixLayer ml = mp.Layers();
		Matrix<ushort> M1(ml);	
	
		
		int nRows = M1.GetNumRows();
		int nCols = M1.GetNumCols();
		
		matrix<ushort> m2(M1); // make a copy of Original matrix into m2
	
		if(!mat_nl_filter(m2,tr.percentile.dVal, tr.winSize.nVal, tr.filterShape.nVal))
			return false;
	
			
		Matrix<ushort> mprev(m_mlCntrl);
		mprev = m2;
		return true;
	}
};

bool preview_percentile_filter(TreeNode& tr, int nViewState, Dialog& dlg, int nViewCntrlID)
{
	static PercentileFilterPreview* s_pPreview = NULL;
	//static GraphPreview* s_pPreview = NULL;
	
	switch(nViewState)
	{
	case GETNVIEW_ON_INIT:
		s_pPreview = new PercentileFilterPreview;
		//s_pPreview = new GraphPreview;
		if(!s_pPreview->Init(dlg, nViewCntrlID))
			return false;
		break;
	case GETNVIEW_ON_DESTROY:
		if(s_pPreview)
			delete s_pPreview;
		s_pPreview = NULL;
		break;
	case GETNVIEW_ON_UPDATE:
		s_pPreview->Update(tr);
		break;
		
	}
		
	return true;
}

void ImagePercentileFilter()
{
	MatrixLayer ml = Project.ActiveLayer();
	if(!ml)
		return;
	
	ml.GetPage().GetName(s_strSourceMatName);
	MatrixPage mp(s_strSourceMatName);
	string strLabel = mp.Label;
	// Use GETN_TREE macro to declare a tree for a Tree style GetN dialog
	GETN_TREE(tr)

	GETN_COMBO(winSize, "Filter Window Size", 13, "3|5|7|9|11|13|17|23|27|31|35|43|47|55|65")
	GETN_LIST(filterShape, "Filter Window Shape", 0, "Square|Circular|Straight Cross (+)|Diagonal Cross (x)")
	GETN_COMBO(percentile, "Percentile Filter(0-100, 50=Median)", 5.0, "0|1|5|25|50|75|95|99|100")	
	//GETN_LIST(output, "Output", 0, "New Window|Replace Data")
	
	
	if( GetNViewBox(tr, "Perentile Filter", strLabel, preview_percentile_filter) )
	{
		MatrixPage matOut;
		matOut.Create("origin.otm", CREATE_HIDDEN);
		image_percentile_filter(s_strSourceMatName, tr, matOut);
	}
}


bool image_percentile_filter(string strOriginalMatrix, TreeNode& tr, MatrixPage& matOut = NULL)
{
	MatrixPage mp(strOriginalMatrix);
	if(!mp)
		return false;
	
	MatrixLayer ml = mp.Layers();
	if(ml.GetInternalData() != FSI_USHORT)
	{
		ml.SetInternalData(FSI_USHORT, TRUE, FALSE);
	}

	Matrix<ushort> M1(ml);	

	
	int nRows = M1.GetNumRows();
	int nCols = M1.GetNumCols();
	
	matrix<ushort> m2(M1); // make a copy of Original matrix into m2
	
	if(!mat_nl_filter(m2,tr.percentile.dVal, tr.winSize.nVal, tr.filterShape.nVal))
		return FALSE;
	
	if(matOut)
	{
		matOut.Rename("PF");
		matOut.Label = "Percentile Filter Result of " + strOriginalMatrix;
		matOut.TitleShow = WIN_TITLE_SHOW_BOTH;
		MatrixLayer mlp = matOut.Layers();
		if(mlp.GetInternalData() != FSI_USHORT)
			mlp.SetInternalData(FSI_USHORT, TRUE, FALSE);
			
		Matrix<ushort> mprev(mlp);
		mprev = m2;
		matOut.SetShow();
		mlp.SetViewImage();
	}
	/*
	mm2 = mat2;
	matrix<USHORT> mat3(mat2);
	if ( !(bOK = ocmath_us_percentile_filter(mat3, nRows, nCols, tr.dPercent2.nVal, tr.nWinXsize.nVal, tr.nWinYsize.nVal, tr.FilterShape.nVal,			tr.dThreshold.nVal) ) )
	{
		ASSERT(FALSE);
		return FALSE;
	}
	mm3=mat3;
	
	mat4 = mat4*(mat3.GetMax()-mat3.GetMin()/2);
	mat4.DotDivide(mm3);
	mm4 = mat4;
	*/
	return TRUE;
}
	
/*

class PagePreview
{
public:
	PagePreview(Dialog& dlg, int nViewCntrlID)
	{
	}
protected:
	bool			m_bReady;
	string			m_strTempPageName;
};

class GraphPreview //: public PagePreview
{
public:
	GraphPreview() {}
	
	bool Init(Dialog& dlg, int nViewCntrlID)
	{
		Control cView = dlg.GetItem(nViewCntrlID);
		if(cView)
		{
			m_gCntrl.CreateControl(cView.GetSafeHwnd());
			m_gCntrl.Create(NOCLICK_ALL, "Origin");
			m_pg = m_gCntrl.GetPage();
			m_lg = m_pg.Layers(0);
			return true;
		}
		return false;
	}
private:
	GraphLayer		m_lg;
	GraphPage		m_pg;
	GraphControl	m_gCntrl;
	string m_strSrcMatrix;
};
*/
	
